; Keyboard.asm - displays keys pressed
;

%define _WINMESSAGES_
%define _WINVKEYS_
%include "Gaz\Win32\Include\Windows.inc"

[BITS 32]
[section .text]

procglobal WinMain, hInstance, hPrevInstance, lpszCmdLine, nCmdShow
	ddlocal		_hwnd
	struclocal	_wndclass, WNDCLASSEX, _msg, MSG
	endlocals
	WinMainPrologue
	mov	esi, ._wndclass
	mov	edi, ._msg
	mov	[esi + WNDCLASSEX.cbSize], dword WNDCLASSEX_size
	mov	[esi + WNDCLASSEX.style], dword CS_HREDRAW | CS_VREDRAW
	mov	[esi + WNDCLASSEX.lpfnWndProc], dword _WndProc
	mov	[esi + WNDCLASSEX.cbClsExtra], dword 0
	mov	[esi + WNDCLASSEX.cbWndExtra], dword 0
	mov	eax, .hInstance
	mov	[esi + WNDCLASSEX.hInstance], eax
	sc LoadIcon, NULL, IDI_APPLICATION
	mov	[esi + WNDCLASSEX.hIcon], eax
	sc LoadCursor, NULL, IDC_ARROW
	mov	[esi + WNDCLASSEX.hCursor], eax
	sc GetStockObject, WHITE_BRUSH
	mov	[esi + WNDCLASSEX.hbrBackground], eax
	mov	[esi + WNDCLASSEX.lpszMenuName], dword NULL
	TEXTlocal szClassName, 'MyClass',0
	mov	[esi + WNDCLASSEX.lpszClassName], dword .szClassName
	sc RegisterClassEx, esi
	cmp	eax, TRUE
	je	near _WinMain_Fail
	TEXTlocal szWndCaption, 'Keyboard reader',0
	sc CreateWindowEx, 0, .szClassName, .szWndCaption, WS_OVERLAPPEDWINDOW | WS_VISIBLE, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, NULL, NULL, .hInstance, NULL
	mov	._hwnd, eax
	sc ShowWindow, ._hwnd, .nCmdShow
	sc UpdateWindow, ._hwnd
_WinMain_Loop:
	sc GetMessage, ._msg, NULL, 0, 0
	cmp	eax, TRUE
	jne	_WinMain_Loop_End
	sc TranslateMessage, ._msg
	sc DispatchMessage, ._msg
	jmp	_WinMain_Loop
_WinMain_Loop_End:
	mov	eax, [edi + MSG.wParam]
	jmp	_WinMain_End
_WinMain_Fail:
	TEXTlocal szErrorMsg, 'Failed to register window class!',0
	sc MessageBox, NULL, .szErrorMsg, .szWndCaption, MB_ICONERROR
_WinMain_End:
	WinMainEpilogue
endproc
;
;-----------------------------------------------------------------------
;
proc _WndProc, hwnd, message, wParam, lParam
	ddlocal		_hdc
	struclocal	_rect, RECT, _ps, PAINTSTRUCT
	ddstatic	_szOtherKey, _lpOutputString
	endlocals
	;
	CallbackPrologue
	;
	switch .message
		case WM_CREATE
			;
			; WM_CREATE is sent when a window is first created by CreateWindow
			; or CreateWindowEx. You can use this to initialise any static variables
			; that need doing so, or perform other initalisation functions. In this
			; example, we set the output string otherwise DrawText (below) will almost
			; certainly crash on the first repaint
			;
			TEXTlocal _szEmpty, '',0
			mov	._lpOutputString, ._szEmpty
			;
			; If you return -1 here, the window will not be created. Returning
			; zero continues the window creation
			;
			xor	eax, eax
			break
		case WM_PAINT
			sc BeginPaint, .hwnd, ._ps
			mov	._hdc, eax
			sc GetClientRect, .hwnd, ._rect
			;
			; Draw the output string onto the window, note that _lpOutputString
			; only holds the address of the string to output, and isn't the
			; string itself
			;
			sc DrawText, ._hdc, ._lpOutputString, -1, ._rect, DT_SINGLELINE | DT_CENTER | DT_VCENTER
			sc EndPaint, .hwnd, ._ps
			xor	eax, eax
			break
		case WM_KEYDOWN
			;
			; WM_KEYDOWN? This message is sent whenever a non-system key is pressed
			; According to the help file, this is a key that is pressed when the
			; Alt key isn't. Whilst we don't worry about it here, so long as the
			; key is held down, WM_KEYDOWN messages are repeatedly sent (at the
			; current typematic rate). When the key is released, a WM_KEYUP
			; message is posted (again, we don't worry about this here, and you
			; will rarely have to).
			;
			; A WM_KEYDOWN message contains a fair bit of information (see the help
			; file for the full details) but the important bit is contained in the
			; wParam parameter - it holds the virtual key code of the key that was
			; pressed. A virtual key code represents a key, but does so in a device-
			; independent way - if you press the Home key on a keyboard you'll
			; always get the VK_HOME key code back, no matter what the underlying
			; hardware. You can find a list of all the constants, the number they
			; actually define and the key they represent in the help file (do a
			; find for Virtual-Key Codes).
			;
			; You may be wondering why we don't process all the other keys from
			; this message. Well, WM_KEYDOWN is useful for detecting non-ASCII
			; keys, but isn't so great when all you want to do is let someone
			; type away. It's much easier to process WM_CHAR messages which
			; send the ASCII character with the message.
			;
			; This may leave you feeling confused - WM_KEYDOWN for some keys and
			; WM_CHAR for others? In fact, _both_ are sent for each keypress, we
			; just choose to deal with the bits we want to where we want to.
			;
			; There are other keyboard messages - WM_KEYUP, WM_SYSKEYDOWN for
			; example - which can be used to detect different types of keypresses
			; (or releases). You can even trap sequences like Alt-F4, so I imagine
			; you can see the power Windows provides in this regard.
			;
			; First zero eax, so we can flag whether we need to redraw the window
			; or not, zero indicates that we don't need to
			;
			xor	eax,eax
			switch .wParam
				case VK_UP
					;
					; Up arrow, so set the string and flag we need to redraw
					;
					TEXTlocal szArrowUp, 'Arrow up',0
					mov	._lpOutputString, dword .szArrowUp
					not	eax
					break
				case VK_DOWN
					TEXTlocal szArrowDown, 'Arrow down',0
					mov	._lpOutputString, dword .szArrowDown
					not	eax
					break
				case VK_LEFT
					TEXTlocal szArrowLeft, 'Arrow left',0
					mov	._lpOutputString, dword .szArrowLeft
					not	eax
					break
				case VK_RIGHT
					TEXTlocal szArrowRight, 'Arrow right',0
					mov	._lpOutputString, dword .szArrowRight
					not	eax
					break
			switchend
			;
			; do we need to redraw the window?
			;
			if eax, ne, 0
				;
				; yes, invalidate the window to tell Windows to send a WM_PAINT message
				;
				sc InvalidateRect, .hwnd, NULL, TRUE
			endif
			xor	eax,eax
			break
		case WM_CHAR
			;
			; a key was sent with an ASCII code held in wParam, so set the
			; first byte of szOtherKey to the code we were just sent
			;
			mov	eax, .wParam
			and	eax, $0ff
			mov	._szOtherKey, eax
			;
			; The curious will be wondering what happens if we were using Unicode.
			; Well, wParam would contain a Unicode character instead of an ASCII
			; one in this case. You could either write your app for Unicode or
			; call IsWindowUnicode and act accordingly
			;
			; set lpOutputString to point to this string
			;
			mov	._lpOutputString, dword .._szOtherKey
			;
			; and invalidate the window
			;
			sc InvalidateRect, .hwnd, NULL, TRUE
			xor	eax,eax
			break
		case WM_DESTROY
			sc PostQuitMessage, 0
			xor	eax,eax
			break
		default
			sc DefWindowProc, .hwnd, .message, .wParam, .lParam
	switchend
	;
	CallbackEpilogue
endproc

[section .bss]

[section .data]
